<?php
require_once 'config.php';
check_login();

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $baslama = $_POST['ise_baslama_saati'] ?? '';
    $bitis = $_POST['ise_bitis_saati'] ?? '';
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($baslama && $bitis && $username) {
        // Ayarları kaydet
        $stmt1 = $pdo->prepare("INSERT INTO ayarlar (isim, deger) VALUES ('ise_baslama_saati', ?) ON DUPLICATE KEY UPDATE deger = VALUES(deger)");
        $stmt1->execute([$baslama]);

        $stmt2 = $pdo->prepare("INSERT INTO ayarlar (isim, deger) VALUES ('ise_bitis_saati', ?) ON DUPLICATE KEY UPDATE deger = VALUES(deger)");
        $stmt2->execute([$bitis]);

        // Patron kullanıcı adı ve şifreyi güncelle
        if ($password !== '') {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt3 = $pdo->prepare("UPDATE patron SET username = ?, password = ? WHERE id = ?");
            $stmt3->execute([$username, $hash, $_SESSION['patron_id']]);
        } else {
            $stmt3 = $pdo->prepare("UPDATE patron SET username = ? WHERE id = ?");
            $stmt3->execute([$username, $_SESSION['patron_id']]);
        }
        $message = "Ayarlar güncellendi.";
        $message_type = "success";
        $_SESSION['patron_username'] = $username;
    } else {
        $message = "Lütfen tüm alanları doldurun.";
        $message_type = "error";
    }
}

// Mevcut değerleri al (sadece iki sütun çekiyoruz)
$stmt = $pdo->query("SELECT isim, deger FROM ayarlar WHERE isim IN ('ise_baslama_saati', 'ise_bitis_saati')");
$ayarlar = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

// Patron bilgisi
$stmt = $pdo->prepare("SELECT username FROM patron WHERE id = ?");
$stmt->execute([$_SESSION['patron_id']]);
$patron = $stmt->fetch();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8" />
  <title>Ayarlar</title>
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f9fafb;
      margin: 0; padding: 40px;
      display: flex;
      justify-content: center;
      align-items: flex-start;
      min-height: 100vh;
    }
    .container {
      background: white;
      padding: 30px 40px;
      border-radius: 10px;
      box-shadow: 0 8px 20px rgba(0,0,0,0.12);
      width: 380px;
    }
    h2 {
      margin-bottom: 25px;
      color: #1e293b;
      text-align: center;
      font-weight: 700;
    }
    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 600;
      color: #334155;
    }
    input[type="time"],
    input[type="text"],
    input[type="password"] {
      width: 100%;
      padding: 12px 14px;
      margin-bottom: 20px;
      border: 1.8px solid #cbd5e1;
      border-radius: 7px;
      font-size: 15px;
      transition: border-color 0.3s;
    }
    input[type="time"]:focus,
    input[type="text"]:focus,
    input[type="password"]:focus {
      border-color: #3b82f6;
      outline: none;
    }
    button {
      width: 100%;
      padding: 14px;
      background-color: #3b82f6;
      color: white;
      font-weight: 700;
      font-size: 16px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      transition: background-color 0.3s;
    }
    button:hover {
      background-color: #2563eb;
    }
    .message {
      padding: 12px;
      margin-bottom: 20px;
      border-radius: 7px;
      font-weight: 600;
      text-align: center;
    }
    .success {
      background-color: #d1fae5;
      color: #065f46;
      border: 1px solid #10b981;
    }
    .error {
      background-color: #fee2e2;
      color: #b91c1c;
      border: 1px solid #f87171;
    }
    a.back-link {
      display: block;
      margin-top: 10px;
      text-align: center;
      color: #2563eb;
      font-weight: 600;
      text-decoration: none;
      font-size: 15px;
    }
    a.back-link:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>

<div class="container">
  <h2>Ayarlar</h2>

  <?php if ($message): ?>
    <div class="message <?= $message_type ?>">
      <?= htmlspecialchars($message) ?>
    </div>
  <?php endif; ?>

  <form method="post" autocomplete="off">
    <label for="ise_baslama_saati">İşe Başlama Saati (HH:MM:SS):</label>
    <input type="time" id="ise_baslama_saati" name="ise_baslama_saati" required value="<?= htmlspecialchars($ayarlar['ise_baslama_saati'] ?? '09:00:00') ?>">

    <label for="ise_bitis_saati">İşi Bırakma Saati (HH:MM:SS):</label>
    <input type="time" id="ise_bitis_saati" name="ise_bitis_saati" required value="<?= htmlspecialchars($ayarlar['ise_bitis_saati'] ?? '18:00:00') ?>">

    <hr style="margin: 25px 0; border: none; border-top: 1px solid #e2e8f0;">

    <label for="username">Kullanıcı Adı (Patron):</label>
    <input type="text" id="username" name="username" required value="<?= htmlspecialchars($patron['username'] ?? '') ?>">

    <label for="password">Yeni Şifre (boş bırakılırsa değişmez):</label>
    <input type="password" id="password" name="password">

    <button type="submit">Kaydet</button>
  </form>

  <a href="index.php" class="back-link">&larr; Geri</a>
</div>

</body>
</html>
