<?php
require_once 'config.php';
check_login();

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    die("Geçersiz ID.");
}

$stmt = $pdo->prepare("SELECT * FROM calisanlar WHERE id = ?");
$stmt->execute([$id]);
$calisan = $stmt->fetch();

if (!$calisan) {
    die("Çalışan bulunamadı.");
}

if (empty($calisan['qr_token'])) {
    $token = bin2hex(random_bytes(10));
    $stmtUpdate = $pdo->prepare("UPDATE calisanlar SET qr_token = ? WHERE id = ?");
    $stmtUpdate->execute([$token, $id]);
    $qrData = $token;
} else {
    $qrData = $calisan['qr_token'];
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8" />
<title><?= htmlspecialchars($calisan['isim']) ?> - Detaylar</title>
<style>
  body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: #f9fafb;
    margin: 20px;
  }
  .container {
    max-width: 400px;
    background: white;
    padding: 25px 30px;
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    margin: auto;
    text-align: center;
  }
  h2 {
    margin-bottom: 15px;
    color: #1e293b;
  }
  .qr-code {
    margin: 20px 0;
  }
  p {
    font-size: 16px;
    color: #334155;
  }
  a.button {
    display: inline-block;
    padding: 10px 18px;
    background-color: #3b82f6;
    color: white;
    border-radius: 6px;
    text-decoration: none;
    font-weight: 600;
    transition: background-color 0.3s;
  }
  a.button:hover {
    background-color: #2563eb;
  }
</style>
</head>
<body>

<div class="container">
  <h2><?= htmlspecialchars($calisan['isim']) ?></h2>
  <p><strong>QR Token:</strong> <?= htmlspecialchars($qrData) ?></p>

  <div class="qr-code">
    <img src="https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=<?= urlencode($qrData) ?>" alt="QR Kod">
  </div>

  <a href="index.php" class="button">Geri</a>
</div>

</body>
</html>
