<?php
require_once 'config.php';
check_login();

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $isim = trim($_POST['isim'] ?? '');

    if ($isim === '') {
        $message = "Çalışan ismi boş olamaz.";
        $message_type = 'error';
    } else {
        $qr_token = bin2hex(random_bytes(16));
        $stmt = $pdo->prepare("INSERT INTO calisanlar (isim, qr_token) VALUES (?, ?)");
        if ($stmt->execute([$isim, $qr_token])) {
            $message = "Çalışan başarıyla eklendi.";
            $message_type = 'success';
        } else {
            $message = "Çalışan eklenirken hata oluştu.";
            $message_type = 'error';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Çalışan Ekle</title>
<style>
  body {
    background: #f9fafb;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0; padding: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
  }
  .form-container {
    background: white;
    padding: 30px 40px;
    border-radius: 10px;
    box-shadow: 0 6px 18px rgba(0,0,0,0.12);
    width: 350px;
  }
  h2 {
    margin-bottom: 25px;
    color: #1e293b;
    text-align: center;
  }
  label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #334155;
  }
  input[type="text"] {
    width: 100%;
    padding: 12px 14px;
    margin-bottom: 20px;
    border: 1.8px solid #cbd5e1;
    border-radius: 6px;
    font-size: 16px;
    transition: border-color 0.3s;
  }
  input[type="text"]:focus {
    border-color: #3b82f6;
    outline: none;
  }
  button {
    width: 100%;
    padding: 14px;
    background-color: #3b82f6;
    color: white;
    font-weight: 700;
    font-size: 16px;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    transition: background-color 0.3s;
  }
  button:hover {
    background-color: #2563eb;
  }
  .message {
    margin-bottom: 20px;
    padding: 12px;
    border-radius: 6px;
    text-align: center;
    font-weight: 600;
  }
  .success {
    background-color: #d1fae5;
    color: #065f46;
  }
  .error {
    background-color: #fee2e2;
    color: #b91c1c;
  }
  a.back-link {
    display: block;
    margin-top: 15px;
    text-align: center;
    color: #2563eb;
    font-weight: 600;
    text-decoration: none;
  }
  a.back-link:hover {
    text-decoration: underline;
  }
</style>
</head>
<body>

<div class="form-container">
  <h2>Yeni Çalışan Ekle</h2>

  <?php if ($message): ?>
    <div class="message <?= $message_type ?>">
      <?= htmlspecialchars($message) ?>
    </div>
  <?php endif; ?>

  <form method="post" autocomplete="off">
    <label for="isim">Çalışan İsmi</label>
    <input type="text" id="isim" name="isim" required placeholder="Çalışan adını girin" autofocus />
    <button type="submit">Ekle</button>
  </form>

  <a href="index.php" class="back-link">&larr; Geri</a>
</div>

</body>
</html>
