<?php
require_once 'config.php';

if (isset($_GET['sil'])) {
  $sil_id = intval($_GET['sil']);
  $stmt = $pdo->prepare("DELETE FROM calisanlar WHERE id=?");
  $stmt->execute([$sil_id]);
  echo "<p style='color:green;'>Çalışan silindi.</p>";
}

$stmt = $pdo->query("SELECT * FROM calisanlar ORDER BY isim");
$calisanlar = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h2>Çalışanlar</h2>
<?php if (count($calisanlar) === 0): ?>
  <p>Çalışan bulunamadı.</p>
<?php else: ?>
<table border="1" cellpadding="8" cellspacing="0" style="width:100%; border-collapse: collapse;">
  <thead>
  <tr>
    <th>İsim</th>
    <th>İşlemler</th>
  </tr>
  </thead>
  <tbody>
  <?php foreach ($calisanlar as $c): ?>
  <tr>
    <td><?=htmlspecialchars($c['isim'])?></td>
    <td>
      <a href="#" onclick="showDetail(<?=$c['id']?>); return false;" title="Ayarlar">&#9881;</a>
      &nbsp;&nbsp;
      <a href="calisanlar.php?sil=<?=$c['id']?>" onclick="return confirm('Silmek istediğinize emin misiniz?');" title="Sil">&#10060;</a>
    </td>
  </tr>
  <?php endforeach; ?>
  </tbody>
</table>
<?php endif; ?>

<div id="detail"></div>

<script>
function showDetail(id) {
  fetch('calisan_ayar.php?id=' + id)
    .then(res => res.text())
    .then(html => {
      document.getElementById('detail').innerHTML = html;
      window.scrollTo(0, document.body.scrollHeight);
    });
}
</script>
