<?php
require_once 'config.php';
check_login();

$stmt = $pdo->query("SELECT * FROM calisanlar ORDER BY isim");
$calisanlar = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="tr">

<head>
  <meta charset="UTF-8" />
  <title>Çalışanlar</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 20px;
      background: #f9fafb;
    }

    h1 {
      color: #1e293b;
      margin-bottom: 20px;
    }

    a.button {
      background-color: #3b82f6;
      color: white;
      padding: 8px 14px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 600;
      margin-right: 8px;
    }

    a.button:hover {
      background-color: #2563eb;
    }

    table {
      border-collapse: collapse;
      width: 100%;
      background: white;
      border-radius: 8px;
      overflow: hidden;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    }

    th,
    td {
      padding: 12px 15px;
      border-bottom: 1px solid #e2e8f0;
      text-align: left;
    }

    th {
      background-color: #3b82f6;
      color: white;
      font-weight: 600;
    }

    tr:hover {
      background-color: #f1f5f9;
    }

    .actions a {
      margin-right: 10px;
      color: #2563eb;
      font-weight: 600;
    }

    .actions a:hover {
      text-decoration: underline;
    }
  </style>
</head>

<body>
  <?php
  check_login();
  $stmt = $pdo->query("SELECT * FROM bildirimler WHERE okundu = 0 ORDER BY tarih DESC");
  $bildirimler = $stmt->fetchAll();
  ?>

  <div style="background:#fff3cd; padding:15px; border-radius:8px; max-width:400px; margin-bottom:20px;">
    <h3 style="color:#856404;">Yeni Bildirimler</h3>
    <?php if ($bildirimler): ?>
      <ul>
        <?php foreach ($bildirimler as $b): ?>
          <li><?= htmlspecialchars($b['mesaj']) ?> <small>(<?= $b['tarih'] ?>)</small></li>
        <?php endforeach; ?>
      </ul>
    <?php else: ?>
      <p>Yeni bildirim yok.</p>
    <?php endif; ?>
  </div>
  <h1>Çalışanlar</h1>
  <a href="calisan_ekle.php" class="button">Çalışan Ekle</a>
  <a href="ayarlar.php" class="button">Ayarlar</a>
  <a href="logout.php" class="button" onclick="return confirm('Çıkış yapmak istediğinize emin misiniz?');">Çıkış</a>

  <table>
    <thead>
      <tr>
        <th>İsim</th>
        <th>İşlemler</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($calisanlar as $c): ?>
        <tr>
          <td><?= htmlspecialchars($c['isim']) ?></td>
          <td class="actions">
            <a href="calisan_detay.php?id=<?= $c['id'] ?>">Detay</a>
            <a href="calisan_sil.php?id=<?= $c['id'] ?>" onclick="return confirm('Silmek istediğinize emin misiniz?');"
              style="color:#dc2626;">Sil</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

</body>

</html>