<?php
require_once 'config.php';
check_login();

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Yalnızca POST isteği kabul edilir']);
    exit;
}

if (!isset($_POST['isim']) || trim($_POST['isim']) === '') {
    echo json_encode(['success' => false, 'message' => 'Çalışan ismi boş olamaz']);
    exit;
}

$isim = trim($_POST['isim']);

// Benzersiz QR token üret (16 bayt -> 32 karakter hex)
$qr_token = bin2hex(random_bytes(16));

try {
    $stmt = $pdo->prepare("INSERT INTO calisanlar (isim, qr_token) VALUES (?, ?)");
    $stmt->execute([$isim, $qr_token]);
    echo json_encode(['success' => true, 'message' => 'Çalışan başarıyla eklendi']);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Veritabanı hatası: ' . $e->getMessage()]);
}
