<?php
require_once 'config.php';

if (isset($_SESSION['patron_id'])) {
    header('Location: index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($username === '' || $password === '') {
        $error = "Lütfen kullanıcı adı ve şifre girin.";
    } else {
        $stmt = $pdo->prepare("SELECT * FROM patron WHERE username = ?");
        $stmt->execute([$username]);
        $patron = $stmt->fetch();

        if ($patron && password_verify($password, $patron['password'])) {
            $_SESSION['patron_id'] = $patron['id'];
            $_SESSION['patron_username'] = $patron['username'];
            header('Location: index.php');
            exit;
        } else {
            $error = "Kullanıcı adı veya şifre hatalı.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Patron Giriş</title>
<style>
  body {
    background: #f0f2f5;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    display: flex;
    align-items: center;
    justify-content: center;
    height: 100vh;
    margin: 0;
  }
  .login-container {
    background: white;
    padding: 30px 40px;
    border-radius: 8px;
    box-shadow: 0 4px 10px rgb(0 0 0 / 0.1);
    width: 320px;
  }
  h2 {
    margin-bottom: 20px;
    text-align: center;
    color: #333;
  }
  input[type=text], input[type=password] {
    width: 100%;
    padding: 10px 14px;
    margin-bottom: 15px;
    border: 1.5px solid #ccc;
    border-radius: 5px;
    font-size: 15px;
    transition: border-color 0.3s;
  }
  input[type=text]:focus, input[type=password]:focus {
    border-color: #3b82f6;
    outline: none;
  }
  button {
    width: 100%;
    padding: 12px;
    background-color: #3b82f6;
    border: none;
    border-radius: 6px;
    color: white;
    font-weight: 600;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s;
  }
  button:hover {
    background-color: #2563eb;
  }
  .error {
    color: #dc2626;
    margin-bottom: 15px;
    text-align: center;
  }
</style>
</head>
<body>

<div class="login-container">
  <h2>Patron Giriş</h2>
  <?php if ($error): ?>
    <div class="error"><?=htmlspecialchars($error)?></div>
  <?php endif; ?>
  <form method="post" autocomplete="off">
    <input type="text" name="username" placeholder="Kullanıcı Adı" required autofocus />
    <input type="password" name="password" placeholder="Şifre" required />
    <button type="submit">Giriş Yap</button>
  </form>
</div>

</body>
</html>
