<?php
require_once 'config.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$calisan_id = intval($data['calisan_id'] ?? 0);
$lat = floatval($data['latitude'] ?? 0);
$lon = floatval($data['longitude'] ?? 0);

if (!$calisan_id || !$lat || !$lon) {
    echo json_encode(['status'=>'error', 'message'=>'Geçersiz veri']);
    exit;
}

// İş yeri koordinatlarını ayarlardan alabiliriz, şimdilik sabit örnek:
$merkez_lat = 40.123456;
$merkez_lon = 32.654321;

function haversine($lat1, $lon1, $lat2, $lon2) {
    $earth_radius = 6371; // km
    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);

    $a = sin($dLat/2) * sin($dLat/2) +
         cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
         sin($dLon/2) * sin($dLon/2);
    $c = 2 * atan2(sqrt($a), sqrt(1-$a));
    return $earth_radius * $c;
}

$distance = haversine($lat, $lon, $merkez_lat, $merkez_lon);

if ($distance > 1) {
    $msg = "Çalışan #$calisan_id konumdan uzak QR okutmaya çalıştı. (Mesafe: " . round($distance,2) . " km)";
    $stmt = $pdo->prepare("INSERT INTO bildirimler (calisan_id, mesaj) VALUES (?, ?)");
    $stmt->execute([$calisan_id, $msg]);

    echo json_encode(['status'=>'error', 'message'=>'Konum işyeri sınırlarının dışında. Patron bilgilendirildi.']);
    exit;
}

// Aynı gün için 2 defa okutma kontrolü
$bugun = date('Y-m-d');
$stmt = $pdo->prepare("SELECT COUNT(*) FROM giriscikislar WHERE calisan_id = ? AND DATE(zaman) = ?");
$stmt->execute([$calisan_id, $bugun]);
$okuma_sayisi = $stmt->fetchColumn();

if ($okuma_sayisi >= 2) {
    echo json_encode(['status'=>'error', 'message'=>'Bugün zaten 2 kez QR kod okutuldu.']);
    exit;
}

$tip = $okuma_sayisi == 0 ? 'giris' : 'cikis';

$stmt = $pdo->prepare("INSERT INTO giriscikislar (calisan_id, tip, zaman, latitude, longitude) VALUES (?, ?, NOW(), ?, ?)");
$stmt->execute([$calisan_id, $tip, $lat, $lon]);

echo json_encode(['status'=>'success', 'message'=> ucfirst($tip)." kaydı başarılı."]);
